/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.container;

import doggytalents.DoggyContainerTypes;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.inventory.container.slot.DogInventorySlot;
import doggytalents.common.talent.PackPuppyTalent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class DogInventoriesContainer
extends AbstractContainerMenu {
    private Level level;
    private Player player;
    private DataSlot slotViewOffset;
    private final List<Dog> chestDogs;
    private final List<DogInventorySlot> dogSlots = new ArrayList<DogInventorySlot>();
    private int totalDogColsCount = 0;
    public static final int VIEW_OFFSET_DATA_ID = 0;
    private int dogSlotsStartsAt = 0;

    public DogInventoriesContainer(int windowId, Inventory playerInventory, List<Dog> chestDogs) {
        super((MenuType)DoggyContainerTypes.DOG_INVENTORIES.get(), windowId);
        this.level = playerInventory.f_35978_.m_9236_();
        this.player = playerInventory.f_35978_;
        this.slotViewOffset = DataSlot.m_39401_();
        this.m_38895_(this.slotViewOffset);
        this.chestDogs = chestDogs;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
        this.dogSlotsStartsAt = this.f_38839_.size();
        this.addDogSlots();
    }

    public void addDogSlots() {
        int VIEWPORT_COLS = 9;
        int view_offset = this.slotViewOffset.m_6501_();
        int current_col = 0;
        for (Dog dog : this.chestDogs) {
            PackPuppyItemHandler packInventory = dog.getTalent((Supplier)DoggyTalents.PACK_PUPPY).map(inst -> inst.cast(PackPuppyTalent.class).inventory()).orElse(null);
            if (packInventory == null) continue;
            int dog_total_cols = Mth.m_14045_((int)dog.getDogLevel((Supplier)DoggyTalents.PACK_PUPPY), (int)0, (int)5);
            for (int col = 0; col < dog_total_cols; ++col) {
                for (int row = 0; row < 3; ++row) {
                    boolean inside_of_viewport;
                    int slot_indx = col * 3 + row;
                    int abs_col = current_col + col;
                    int viewX = 8 + 18 * (current_col + col - view_offset);
                    int viewY = 18 * row + 18;
                    DogInventorySlot slot = new DogInventorySlot(dog, this.player, (IItemHandler)packInventory, abs_col, row, col, slot_indx, viewX, viewY);
                    this.addDogSlot(slot);
                    int viewport_col = slot.getAbsoluteCol() - view_offset;
                    boolean bl = inside_of_viewport = viewport_col >= 0 && viewport_col < 9;
                    if (inside_of_viewport) continue;
                    slot.setEnabled(false);
                }
            }
            this.totalDogColsCount += dog_total_cols;
            current_col += dog_total_cols;
        }
    }

    public void m_7511_(int id, int data) {
        super.m_7511_(id, data);
        if (id == 0) {
            this.reDrawDogSlots(data);
        }
    }

    private void reDrawDogSlots(int newViewOffset) {
        for (int i = 0; i < this.dogSlots.size(); ++i) {
            DogInventorySlot slot0 = this.dogSlots.get(i);
            DogInventorySlot new_slot = new DogInventorySlot(slot0, 8 + 18 * (slot0.getAbsoluteCol() - newViewOffset));
            this.replaceDogSlot(i, new_slot);
            int viewport_col = slot0.getAbsoluteCol() - newViewOffset;
            if (viewport_col >= 0 && viewport_col < 9) continue;
            new_slot.setEnabled(false);
        }
    }

    private void addDogSlot(DogInventorySlot slotIn) {
        this.m_38897_((Slot)slotIn);
        this.dogSlots.add(slotIn);
    }

    private void replaceDogSlot(int i, DogInventorySlot slotIn) {
        this.dogSlots.set(i, slotIn);
        DogInventorySlot s = slotIn;
        this.f_38839_.set(((Slot)s).f_40219_, (Object)slotIn);
    }

    public int getTotalNumColumns() {
        return this.totalDogColsCount;
    }

    public int getViewOffset() {
        return this.slotViewOffset.m_6501_();
    }

    public void setViewOffset(int offset) {
        this.m_7511_(0, offset);
    }

    public List<DogInventorySlot> getSlots() {
        return this.dogSlots;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int i) {
        Slot slot = (Slot)this.f_38839_.get(i);
        if (slot == null || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack moveStack0 = ItemStack.f_41583_;
        ItemStack moveStack = slot.m_7993_();
        moveStack0 = moveStack.m_41777_();
        boolean moveResult = false;
        boolean clickedDogSlot = i >= this.dogSlotsStartsAt && i < this.f_38839_.size();
        moveResult = clickedDogSlot ? this.m_38903_(moveStack, 0, this.dogSlotsStartsAt, true) : this.m_38903_(moveStack, this.dogSlotsStartsAt, this.f_38839_.size(), false);
        if (!moveResult) {
            return ItemStack.f_41583_;
        }
        if (moveStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (moveStack.m_41613_() == moveStack0.m_41613_()) {
            return ItemStack.f_41583_;
        }
        return moveStack0;
    }
}

